# Big Bang Release Notes

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/), and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

---
## [2.17.0]

- [!2.17.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.17.0); List of merge requests in this release.

## [2.16.0]

- [!2.16.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.16.0); List of merge requests in this release.

## [2.15.0]

- [!2.15.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.15.0); List of merge requests in this release.

## [2.14.0]

- [!2.14.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.14.0); List of merge requests in this release.

## [2.13.1]

- [!1812](https://repo1.dso.mil/big-bang/bigbang/-/issues/1812): neuvector enforcer correct host-path-mount exception

## [2.13.0]

- [!2.13.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.13.0); List of merge requests in this release.

## [2.12.0]

- [!2.12.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.12.0); List of merge requests in this release.

## [2.11.1]

- [!3146](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/3146): Kyverno update to 3.0.0-bb.3
- [!3170](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/3170): GitlabRunner update to 0.52.0-bb.6
- [!3178](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/3178): Gitlab update to 7.3.4-bb.0
- [!3187](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/3187): fluentbit update to 0.37.0-bb.1

## [2.11.0]

- [!2.11.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.11.0); List of merge requests in this release.

## [2.10.0]

- [!2.10.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.10.0); List of merge requests in this release.

## [2.9.0]

- [!2.9.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.9.0); List of merge requests in this release.

## [2.8.0]

- List of merge requests in this release.

- [!2971](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2971): Grafana chart indentation 6 -> 4
- [!2950](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2950): velero update to 4.0.3-bb.0
- [!2973](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2973): gitlab update to 7.2.0-bb.0
- [!2974](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2974): authservice update to 0.5.3-bb.12
- [!2936](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2936): argocd update to 5.39.0-bb.0
- [!2964](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2964): neuvector update to 2.4.5-bb.2
- [!2966](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2966): loki update to 5.9.2-bb.0
- [!2975](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2975): promtail update to 6.13.1-bb.0
- [!2930](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2930): Re-add IB key to Kyverno Policies test-values
- [!2963](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2963): kyvernoPolicies update to 1.1.0-bb.9
- [!2972](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2972): istio & operator update to 1.18.2-bb.0
- [!2938](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2938): Add 'comments' field to schema
- [!2957](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2957): fix for ca-secret creation logic
- [!2955](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2955): harbor update to 1.12.2-bb.7
- [!2958](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2958): anchore update to 1.26.1-bb.0
- [!2977](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2977): gitlab update to 7.2.2-bb.0
- [!2961](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2961): Fixing conditional for grafana extraSecretMounts

## [2.7.0]

- [!2.7.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.7.0); List of merge requests in this release.


## [2.6.0]

- [!2.6.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.6.0); List of merge requests in this release.

## [2.5.0]

- [!2.5.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.5.0); List of merge requests in this release.

## [2.4.0]

- [!2.4.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.4.0); List of merge requests in this release.

## [2.3.0]

- [!2.3.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.3.0); List of merge requests in this release.

## [2.2.0]

- [!2.2.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.2.0); List of merge requests in this release.

## [2.1.0]

- [!2.1.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.1.0); List of merge requests in this release.


## [2.0.1]

- [!2713](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2713): Bug fix for Gitlab chart backup job template
- [!2712](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2712): Bug fix for Gitlab Runner network policy ranging template
- [!2707](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2707): Bug fix for missing Monitoring SSO keys in schema
- [!2703](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2703): Bug fix for Mattermost and Nexus HelmRepos

## [2.0.0]

- [!2.0.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=2.0.0); List of merge requests in this release.

#### Breaking Changes

This major release contains breaking changes. Review the [release notes](https://repo1.dso.mil/big-bang/bigbang/-/releases/2.0.0) or the [blog post](https://docs-bigbang.dso.mil/latest/blog/2-0-breaking-changes/) for more details before upgrading.

## [1.57.1]

- [!2659](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests/2659): Fix wrong ArgoCD image version

## [1.57.0]

- [!1.57.0](https://repo1.dso.mil/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.57.0); List of merge requests in this release.

## [1.56.0]

- [!1.56.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.56.0); List of merge requests in this release.

## [1.55.0]

- [!1.55.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.55.0); List of merge requests in this release.

## [1.54.0]

- [!1.54.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.54.0); List of merge requests in this release.

## [1.53.0]

- [!1.53.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.53.0); List of merge requests in this release.

## [1.52.0]

- [!1.52.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.52.0); List of merge requests in this release.

## [1.51.0]

- [!1.51.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.51.0); List of merge requests in this release.
## [1.50.0]

- [!1.50.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.50.0); List of merge requests in this release.

## [1.49.0]

- [!1.49.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.49.0); List of merge requests in this release.

## [1.48.0]

- [!1.48.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.48.0); List of merge requests in this release.

## [1.47.0]

- [!1.47.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.47.0); List of merge requests in this release.

## [1.46.1]

- [!2243](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/2243): Fix Loki Monolith mTLS

## [1.46.0]

- [!1.46.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.46.0); List of merge requests in this release.

## [1.45.0]

- [!1.45.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.45.0); List of merge requests in this release.

## [1.44.0]

- [!1.44.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.44.0); List of merge requests in this release.

## [1.43.0]

- [!1.43.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.43.0); List of merge requests in this release.

## [1.42.0]

- [!1.42.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.42.0); List of merge requests in this release.

## [1.41.0]

- [!1.41.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.41.0); List of merge requests in this release.

## [1.40.0]

- [!1.40.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.40.0); List of merge requests in this release.

## [1.39.0]

- [!1.39.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.39.0); List of merge requests in this release.

## [1.38.0]

- [!1.38.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.38.0); List of merge requests in this release.

## [1.37.0]

- [!1.37.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.37.0); List of merge requests in this release.

## [1.36.0]

- [!1.36.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.36.0); List of merge requests in this release.

## [1.35.0]

- [!1.35.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.35.0); List of merge requests in this release.


## [1.34.0]

- [!1.34.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.34.0); List of merge requests in this release.

## [1.33.0]

- [!1.33.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.33.0); List of merge requests in this release.

## [1.32.0]

- [!1.32.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.32.0); List of merge requests in this release.

## [1.31.0]

- [!1.31.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.31.0); List of merge requests in this release

## [1.30.1]

- [!1495](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/1495): Update ArgoCD image to 2.3.2

## [1.30.0]

- [!1.30.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.30.0); List of merge requests in this release.

## [1.29.0]

- [!1.29.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.29.0); List of merge requests in this release.

## [1.28.0]

- [!1.28.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.28.0); List of merge requests in this release.

## [1.27.1]

- [!1346](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/1346): Update to re-enable Jaeger's sidecars

## [1.27.0]

- [!1.27.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.27.0); List of merge requests in this release.

## [1.26.0]

- [!1.26.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.26.0); List of merge requests in this release.

## [1.25.1]

- [!1256](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/1256): Gitlab version bump to `5.6.2-bb.0` app version `14.6.2`

## [1.25.0]

- [!1.25.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.25.0); List of merge requests in this release.

## [1.24.0]

- [!1.24.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.24.0); List of merge requests in this release.

## [1.23.0]

- [!1.23.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.23.0); List of merge requests in this release.

## [1.22.0]

- [!1.22.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.22.0); List of merge requests in this release.

## [1.21.0]

- [!1.21.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.21.0); List of merge requests in this release.

## [1.20.0]

- [!1.20.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.20.0); List of merge requests in this release.

## [1.19.0]

- [!1.19.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.19.0); List of merge requests in this release.

## [1.18.0]

- [!1.18.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.18.0); List of merge requests in this release.

## [1.17.0]

- [!1.17.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.17.0); List of merge requests in this release.

## [1.16.2]

- [!919](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/919): Sonarqube version `9.2.6-bb.17-1` version bump to address erroneous duplicate template definitions for tolerations, nodeSelector & affinity

## [1.16.1]

- [!887](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/887): Twistlock Network Policy & BigBang/Package value `networkPolicies.nodeCidr` for defender to console communication
- [!890](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/890): Adding violation exception for twistlock-defenders to use selinux `spc_t` settings

## [1.16.0]

- [!1.16.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.16.0); List of merge requests in this release.

## [1.15.3]

- [!887](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/887): Twistlock Network Policy & BigBang/Package value `networkPolicies.nodeCidr` for defender to console communication
- [!852](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/852): Adding violation exceptions to stop Gatekeeper blocking twistlock console deployment
- [!890](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/890): Adding violation exception for twistlock-defenders to use selinux `spc_t` settings

## [1.15.2]

- [!846](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/846): Istio-cni hub correction to point to valid repo in registry1 & Add install-cni image to synker.yaml for air-gapped environments

## [1.15.1]

- [!834](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/834): Update istio to version 1.9.8
- [!818](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/818): Fix minio istio pass down
- [!831](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/831): Fix monitoring hostNetwork violation
- [!835](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/835): Fix fluentbit hostFilesystem violation

## [1.15.0]

- [!1.15.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.15.0); List of merge requests in this release.

## [1.14.1]

- [!771](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/771): Intermediate update to authservice package to allow for cleaner certificate formatting
- [!782](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/782): Bumping Authservice tag to 0.4.0-bb.13 to fix mapping for values passed to redis sub-chart and uploading correct dependency sub-chart

## [1.14.0]

- [!1.14.0](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.14.0); List of merge requests in this release.

## [1.13.1]

- [!722](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/722): Bumping Gatekeeper tag, reducing pod footprint, cleaning up constraints
- [!730](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/730): Bumping Gatekeeper tag, properly excluding all of "kube-system" namespace from gatekeeper via upstream recommendation, removing "kube-system" exclusions from package values.

## [1.13.0]

- [!1.13.0 Merge Requests](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.13.0); List of Merge Requests in this Release

## [1.12.1]

- [!769](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/769): Add `kube-system` namespace exception to all constraints that cause violations

## [1.12.0]

- [!1.12.0 Merge Requests](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.12.0); List of Merge Requests in this Release

## [1.11.0]

- [!1.11.0 Merge Requests](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.11.0); List of Merge Requests in this Release

## [1.10.0]

- [!1.10.0 Merge Requests](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests?scope=all&utf8=%E2%9C%93&state=merged&milestone_title=1.10.0); List of Merge Requests in this Release

## [1.9.1]

- [!534](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/534): Bumping monitoring chart version - Addresses un-reconcilable state of monitoring package when upgrading from previous version of BigBang to 1.9.0

## [1.9.0]

- [!445](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/445): Nexus added to BB
- [!488](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/488): Authservice support external redis service
- [!490](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/490): New monitoring helm tests
- [!492](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/492): Add new robot account to CI
- [!495](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/495): Add shanks as maintainers
- [!497](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/497): CAC CI upgrades
- [!499](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/499): Mattermost Operator optional network policies
- [!503](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/503): Sonarqube optional network policies
- [!504](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/504): Gitlab optional network policies
- [!509](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/509): feat: Bumping monitoring tag version
- [!510](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/510): ECK Operator optional network policies
- [!511](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/511): Authservice optional network policies
- [!513](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/513): Monitoring optional network policies
- [!514](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/514): Cluster Auditor & OPA Gatekeeper constraint-templates and added conditional enforcement

### Upgrade Notices

This update includes network policies for multiple packages, please refer to each package's individual documentation on implementation.

### Known Issues

- If the following error is seen on any helm releases `scheme "" not supported` try updating flux to latest ib images. A simple way to do this is by adding registry credentials to the flux-system namespace and applying the flux.yaml:

```bash
kubectl create secret docker-registry private-registry --docker-server=registry1.dso.mil --docker-username=<Your IronBank Username> --docker-password=<Your IronBank Personal Access Token> --docker-email=<Your E-mail Address> -n flux-system
curl https://repo1.dso.mil/platform-one/big-bang/bigbang/-/raw/master/scripts/deploy/flux.yaml | kubectl apply -f -
```

- There is a [known issue](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/issues/329) with Velero ability to restore PersistentVolumes.

## [1.8.0]

- [!447](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/447): Sonarqube upgrade app version 8.7.1 chart version 9.2.6-bb.8
- [!406](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/406): Authservice Support For Non Keycloak OIDC Endpoints
- [!459](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/459): Gitlab update to fix monitoring
- [!463](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/463),[!480](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/480): update codeowners
- [!462](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/462): Document GitLab package architecture in charter
- [!453](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/453): Set Global Timeout for Flux & Allow for HelmRelease Flux Settings to be Populated via Values File
- [!466](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/466): Updating name for kiali oidc secret secret
- [!465](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/465): Mattermost update app version 5.34.2 chart version 0.1.5-bb.0
- [!467](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/467): update changelog for release 1.7.0
- [!468](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/468): Modify continuous integration (CI) pipeline script execution
- [!474](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/474): Update twistlock app version 21.04.412 chart version 0.0.4-bb.0
- [!464](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/464): Documentation updates
- [!475](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/475): Anchore upgrade app version 0.9.3 chart version 1.12.13-bb.0
- [!430](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/430): Charter update for istio architecture
- [!451](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/451),[!481](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/481),[!482](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/482): Breakout secrets into individual files in Package templates
- [!417](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/417): update Kibana
- [!350](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/350): Authservice Redirect URLs dont respect virtual service name overrides
- [!485](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/485): ArgoCD upgrade app version 1.8.4 chart version 2.14.7-bb.5
- [!476](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/476): Charter documentation updates
- [!134](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/134),[!489](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/489): BETA release of Keycloak app version 13.0.0 helm chart version 11.0.0
- [!342](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/342): Upgrade elasticsearch-kibana package app version 7.10.x chart version 0.1.11-bb.0
- [!457](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/457): Add labels to authservice namespace in compliance with charter

### Upgrade Notices

- Release 1.8.0 upgrades Elasticsearch and Kibana to 7.10 versions and if the [autoRollingUpgrade](https://repo1.dso.mil/platform-one/big-bang/apps/core/elasticsearch-kibana/#autorollingupgrade) job does not complete successfully or is interfered with it could cause ECK data loss. Please leave autoRollingUpgrade enabled and read [documentation](https://repo1.dso.mil/platform-one/big-bang/apps/core/elasticsearch-kibana/-/blob/main/docs/troubleshooting.md) to prepare for upgrade issues.

### Known Issues

- If the following error is seen on any helm releases `scheme "" not supported` try updating flux to latest ib images. A simple way to do this is by adding registry credentials to the flux-system namespace and applying the flux.yaml:

```bash
kubectl create secret docker-registry private-registry --docker-server=registry1.dso.mil --docker-username=<Your IronBank Username> --docker-password=<Your IronBank Personal Access Token> --docker-email=<Your E-mail Address> -n flux-system
curl https://repo1.dso.mil/platform-one/big-bang/bigbang/-/raw/master/scripts/deploy/flux.yaml | kubectl apply -f -
```

- There is a [known issue](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/issues/329) with Velero ability to restore PersistentVolumes.

## [1.7.0]

- [!453](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/453): Global Timeout for flux and allow for HR flux settings to be populated via values
- [!459](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/459): Gitlab monitoring fix
- [!406](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/406): Authservice Support For Non Keycloak OIDC Endpoints
- [!447](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/447): Sonarqube updated to 8.7.1
- [!446](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/446): Mattermost elastic integration
- [!437](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/437): Postrenders
- [!440](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/440): GitLab Upgrade to 13.10.3
- [!450](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/450): Ironbank image version check script

- [!369](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/369): Update development-environment
- [!371](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/371): Update 2_getting_started
- [!483](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/438): cluster auditor architecture
- [!454](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/454): Storage Documentation
- [!221](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/221): Add initial thoughts on Hugo
- [!408](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/408): Adding Architecture Doc for ek package
- [!462](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/462): Document GitLab package architecture in charter
- [!463](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/463): Update CODEOWNERS

### Upgrade Notice

#### Sonarqube Release Information

This release comes with a new version of Sonarqube which requires a manual database upgrade that can be easily done through the web interface. If you see a message stating Sonarqube is under maintenance go to the following url and click update database:

```
https://sonarqube.your.url/setup
```

After a few minutes you should be able to log back in.

### Known Issues

If the following error is seen on any helm releases `scheme "" not supported` try updating flux to latest ib images. A simple way to do this is by adding registry credentials to the flux-system namespace and applying the flux.yaml:

```bash
kubectl create -n flux-system secret docker-registry private-registry --docker-server="https://registry1.dso.mil" --docker-username='<IB_Username>' --docker-password="<CLI_TOKEN>"
kubectl apply -f scripts/deploy/flux.yaml
```

## [1.6.2]

- [!455](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/455): gatekeeper values not hardcoded

## [1.6.1]

- [#19](https://repo1.dso.mil/platform-one/big-bang/apps/core/istio-controlplane/-/issues/19): istio-cni image hub reverted to dsop.io domain
- [#387](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/issues/387): Latest Fluent-Bit release removed Grafana Dashboard Functionality

## [1.6.0]

### Upgrade Notice

This update includes several major changes to istio. Kiali and Jaeger are now separated into their own repos, helmreleases, and namespaces.

A manual cleanup task is required to delete the previous Kiali and Jaeger deployments post upgrade:

```bash
kubectl delete deploy -n istio-system -l app=kiali
kubectl delete deploy -n istio-system -l app=jaeger
```

### Known Issues

This update includes an update to the Anchore chart. There is a [known issue](https://github.com/anchore/anchore-engine/issues/882) with running this version (and some previous versions) on FIPS enabled nodes. All Anchore services continue to function properly on non-FIPS nodes. Once an upstream fix is pushed, we will update the BB version accordingly.

Anchore's default resource requests/limits (specifically for memory for the RBAC Manager) may be problematic depending on the customer and usage. Currently Big Bang consumes the defaults from the upstream chart, but Anchore also provides a list of [requirements](https://docs.anchore.com/current/docs/overview/requirements/) that address best practices for configuration for production workloads. These recommendations can be used as BB value overrides to specify resource limits and requests (example: [RBAC Manager](https://repo1.dso.mil/platform-one/big-bang/apps/security-tools/anchore-enterprise/-/blob/main/chart/values.yaml#L868)).

- [!436](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/436): Resolve "fluentbit requires modification to work when selinux: Enforcing"
- [!416](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/416): Fix Minio SecurityContext for Mattermost
- [!385](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/385): update anchore to 1.12.7-bb.2
- [!330](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/330): upgrade to istio 1.8.4, split jaeger and kiali into separate deployments
- [!427](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/427): IronBank image for Cluster Auditor
- [!428](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/428): feat: Bumping eck-operator to 1.4.0-bb.1
- [!421](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/421): Resolve "Upgrade eck-operator to 1.4.0"
- [!405](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/405): Upgrade OPA Gatekeeper
- [!443](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/443): Resolve "Fluentbit upgrade to application version 1.7.4"
- [!442](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/442): Resolve "feat: Update authservice to use latest IB image and templating"
- [!432](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/432): feat: ek package to 0.1.8-bb.0 for pod lifecycle support
- [!418](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/418): Minio VS update

There are additional minor changes and documentation updates that are included with this release. Full changes can always be seen by viewing the commit logs and completed MRs.

## [1.5.0]

### Upgrade Notice

This update includes several additions to fluent-bit which are recommended for production environments to increase reliability of log ingestion to the ECK stack.

This is mainly accomplished within fluent-bit by introducing a [filesystem storage buffer](https://docs.fluentbit.io/manual/administration/buffering-and-storage#filesystem-buffering-to-the-rescue) interacting with a new `hostPath` volume in fluent-bit containers.
By default, this is mounted to nodes at `/var/log/flb-storage/`, however it can be updated in the package's values in 3 places:

```yaml
storage_buffer:
  path: /var/log/flb-storage/

extraVolumes:
  - hostPath:
      path: /var/log/flb-storage/
      type: DirectoryOrCreate
    name: flb-storage

extraVolumeMounts:
  - mountPath: /var/log/flb-storage/
    name: flb-storage
```

- [!386](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/386): Updated Fluentbit to 1.7.2 which fixes #335.
- [!356](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/356): Enabled flux monitoring via Prometheus/Grafana in Monitoring package.
- [!380](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/380): Fixed `eckoperator.enabled` conditional.
- Added and Documented Affinity support.
  - [!379](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/379) Twistlock
  - [!393](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/393) Cluster Auditor

## [1.4.0]

### Upgrade Notice

This update includes updated `EnvoyFilters` for `authservice` to fix #65 and is a component of a future upgrade to istio 1.8 (#191).

**After upgrading BigBang to this version, you must follow the steps below to ensure apps protected by `authservice` are still protected.**

In order to ensure sso for all services protected by `authservice` remain functional (`kiali`, `jaeger`, `prometheus`, and `alertmanager`), the `istio-proxy` sidecar attached to the `haproxy` infront of the services must be updated to `1.7.7`.

The easiest way to do this is to cycle the pod:

```bash
kubectl delete po -n authservice -l app.kubernetes.io/instance=authservice-haproxy-sso
```

> **Note**: these 4 services (`kiali`, `jaeger`, `prometheus`, and `alertmanager`) will be unavailable for ~10s while the pod cycles. In the future we aim to provide an HA implementation of authservice's haproxy so the above operations can happen without downtime.

- [!300](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/300): Velero Addon Addition
- [!308](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/308): BigBang values migrated to Secret objects parsed by `HelmRelease` objects within chart. (also fixes #221)
- [!357](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/357): Updated Anchore (Engine 0.9.3, Enterprise 3.0.2).
- [!333](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/333): Updated Mattermost (Operator: 1.13.0, Instance: 5.32.1).
- [!346](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/346): Redis Integration with Anchore Enterprise Package.
- [!318](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/318): Redis Integration with ArgoCD Package.

## [1.3.0]

- [!322](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/322): Updated anchore to 0.9.2, enterprise 3.0.1, this also fixes #135
- [!309](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/309): Add support for Gitlab CAC signed commits and custom CAs
- [!311](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/311): Update minio to `RELEASE.2020-11-19T23-48-16Z` and expose more user configuration options
- [!220](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/220): Added consolidatedflux installation (without `flux` cli)
- [!319](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/319): Updated gitlab-runner to `13.9.0` IronBank image (note this uses a different chart schema than previous versions, see [here](https://docs.gitlab.com/runner/install/kubernetes.html#additional-configuration) for more information)
- [!340](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/340): Package `bigbang` repo in `repositories.tar.gz` release artifact

In addition, [Big Bang Pre-requisites](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/blob/1.4.0/docs/d_prerequisites.md) has been added as a location to store all (known) pre-requisites for running BigBang on various distributions. Over time, more distributions will be added as they are tested, community (and vendor) contributions are welcomed!

## [1.2.0]

- [!270](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/270): upgrade to flux 0.7.x, this requires updating flux and fixes #13
- [!250](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/250): Filename spelling correction in scripts directory
- [!259](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/259), [!265](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/265), [!274](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/274): documentation updates
- [!263](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/263), [!271](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/271): Update codeowners
- [!263](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/263): add missing enterprise Anchore images to airgap bundle
- [!237](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/237): add gitlab-runner to test values
- [!266](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/266): update fluentbit package version
- [!269](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/269): Update charter/PackageOwner.md
- [!256](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/256): update developer documentation
- [!272](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/272): Remove CI jobs that check for things no longer required as part of the developer workflow
- [!264](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/264), [!238](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/238): Update BigBang repo url references from "umbrella" to "bigbang"
- [!249](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/249): image for gatekeeper is set in the chart and should not be hardcoded in the HelmRelease
- [!202](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/202): add initial support for openshift (ocp)
- [!272](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/272): upgrade argocd helm chart to 2.14.7-bb.0
- [!232](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/232): Twistlock IB image and VirtualServcie customization
- [!210](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/210): only run cluster tests when chart contents have changed
- [!279](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/279): remove hardcoded ArgoCD server url config, allow users to set their own sso url
- [!215](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/215): add sample sso values
- [!286](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/286): add Ironbank defender image to synker config
- [!287](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/287): add gitlab runner images to synker config
- [!288](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/288): split minio into minio operator and minio and move to addons
- [!255](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/255): Integrate Mattermost Operator as an addon
- [!273](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/273): Integrate Mattermost as an addon
- [!291](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/291): enable MinIO in CI tests
- [!290](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/merge_requests/290): upgrade Mattermost chart version. Uses latest IronBank image

## [1.1.0]

- [&2](https://repo1.dso.mil/groups/platform-one/big-bang/-/epics/2): Add support for Gitlab (with sso) 13.8.0
- [&3](https://repo1.dso.mil/groups/platform-one/big-bang/-/epics/3): Add support for Gitlab Runners 13.2.2
- [&7](https://repo1.dso.mil/groups/platform-one/big-bang/-/epics/7): Add support for SonarQube (with sso) 8.6
- [&15](https://repo1.dso.mil/groups/platform-one/big-bang/-/epics/15): Add support for Anchore (with sso) 0.8.1
- [#129](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/issues/129): Updated FluentBit to 1.6.3
- [#63](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/issues/63): Fix bug with elasticsearch failing to start due to invalid file permissions
- [#49](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/issues/49): Add consistent labels to authservice deployment
- [#32](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/issues/32): Add support for PodAntiAffinity and NodeAffinity for elasticsearch deployments
- [#6](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/issues/6): Add support for new elasticsearch cluster node types
- [#16](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/issues/16): Fix bug with incorrect git credentials being created when specifying a private repository
- [#66](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/issues/66): Fix bug with EnvoyFilter being applied in the wrong non-global namespace
- [#99](https://repo1.dso.mil/platform-one/big-bang/bigbang/-/issues/99): Fix bug that allowed for incorrect ImagePullSecrets to be created when providing incomplete credentials

## [1.0.8]

- Added support for deployment of Minio operator and instance deployment of minio.

## [1.0.7]

- Added Kubernetes labels to all objects created by umbrella
- Add OIDC integration for Grafana
- Allow creation of wildcard cert for istio ingress to be passed to BigBang chart

## [1.0.6]

- Added [HAProxy Addon](https://repo1.dso.mil/platform-one/big-bang/apps/sandbox/haproxy)
- Added support for automatically populating configs and settings for the following placing SSO in front of apps without support:

```
istio:
  sso:
    enabled: true
    prometheus:
      client_id:
      client_secret:
    alertmanager:
      client_id:
      client_secret:

monitoring:
  sso:
    enabled: true
    kiali:
      client_id:
      client_secret:
    jaeger:
      client_id:
      client_secret:
```

- Added authservice namespace where authservice addon and haproxy deployment will be created.
- Added global sso options for umbrella which will be applied to all configured authservice chains:

```
sso:
  oidc:
    host: login.dso.mil
    realm: baby-yoda
  certificate_authority: ''
  jwks: ""
  client_id: ""
  client_secret: ""
```

- Updated syntax for authservice chains definition.

## [1.0.5]

- Bumped monitoring chart to consume kiwigrid/sidecar from IronBank

## [1.0.4]

- Bug fix where argocd's VirtualService wouldn't recieve the top level hostname value.

## [1.0.3]

- Added [Gitlab](https://repo1.dso.mil/platform-one/big-bang/apps/developer-tools/gitlab)
- Added ability to provide multiple registry credentials while maintaining current capabilities:

```
registryCredentials:
  username: registry1user
  password: somesecretpassword
```

or

```
registryCredentials:
- registry: registry1.dso.mil
  username: registry1user
  password: somesecretpassword
- registry: registry.dsop.io
  username: registry1user
  password: somesecretpassword
- registry: somewhere.else.io
  username: someuser
  password: someothersecret
```

will correctly create the ImagePullSecrets for all those registries

## [1.0.2]

### Changed

- Updated istio-controlplane to [1.7.3-bb.5](https://repo1.dso.mil/platform-one/big-bang/apps/core/istio-controlplane/-/tags/1.7.3-bb.5) to allow
  for setting ingressgateway to use nodeports

## [1.0.1]

### Changed

- Updated Istio Control plane to support Node Ports for ingressGateway
- Update Istio Control plane to support SSO for Kiali and Jaeger
- Update Authservice to refact definitions of filter chains
- Updated documentation

---

## [0.0.4] - 2020-12-16

### Changed

- Update Monitoring to [11.0.0-bb.2](https://repo1.dso.mil/platform-one/big-bang/apps/core/monitoring/-/tags/11.0.0-bb.2)

---

## [0.0.3] - 2020-12-15

### Added

- Documentation in [docs](./docs)

### Changed

- Updated Argo to [2.9.5-bb.1](https://repo1.dso.mil/platform-one/big-bang/apps/core/argocd/-/merge_requests/10) for Iron Bank images
- Updated Authservice to [0.1.3-bb.0](https://repo1.dso.mil/platform-one/big-bang/apps/sandbox/authservice/-/blob/master/CHANGELOG.md#013-bb0) for authservice secret generation: https://repo1.dso.mil/platform-one/big-bang/apps/sandbox/authservice/-/blob/master/CHANGELOG.md#013-bb0
- Updated ECK-Operator to [1.3.1-bb.1](https://repo1.dso.mil/platform-one/big-bang/apps/core/eck-operator/-/tags/1.3.0-bb.1)
- Updated Twistlock to [0.0.2-bb.0](https://repo1.dso.mil/platform-one/big-bang/apps/security-tools/twistlock/-/tags/0.0.2-bb.0) to add istio.enabled flag
- Updated Elasticsearch Kibana to [0.1.2-bb.0](https://repo1.dso.mil/platform-one/big-bang/apps/core/elasticsearch-kibana/-/tags/0.1.2-bb.0) and Pass istio.enabled to Elasticsearch Kibana

---

## [0.0.2] - 2020-12-11

### Added

- Initial release of Big Bang

---
