# Developer Documentation

[[_TOC_]]

## Preface

Please read through the documentation linked here and in the [understanding big bang folder](https://repo1.dso.mil/big-bang/bigbang/-/tree/master/docs/understanding_bigbang) to understand Big Bang concepts and development standards. Study all the documents carefully before you start developing.  

## Communications

Join MatterMost channels to ask questions and communicate with the team. Here is the list of relevant Mattermost channels for BigBang development:  

* [Value Stream - Big Bang](https://chat.il2.dso.mil/platform-one/channels/team---big-bang)
* [Topic - Big Bang Documentation](https://chat.il2.dso.mil/platform-one/channels/topic-big-bang-documentation)

## Set up a development environment

[Development Environment](./development-environment.md)

## Package Requirements

[Big Bang Package Integration Guide](./package-integration/README.md) and [BBTOC Graduated Requirements](https://repo1.dso.mil/platform-one/bbtoc/-/tree/master/process#graduated-project-requirements)

## Package Development

[Develop a Big Bang Package](./develop-package.md)

## Add Package to Big Bang

[Integrate Package with Big Bang](./package-integration/README.md)

## Package Owner Overview

[Package Owner Requirements & Overview](./package-integration/ownership.md)

## Big Bang Code Through Party Bus Pipeline

[Code Through Party Bus MDO Pipeline](./mdo-partybus-pipelines.md)
