# Big Bang Licensing Model Overview

While Big Bang is open source and free to use, the same cannot be said of its components. The licensing requirements of components requires a nuanced explanation. The intent of this document is to be a self service resource to help consumers of Big Bang make an informed decision regarding licenses they may need to successfully deploy an ATO'able DevSecOps Platform using Big Bang.

## What Licenses Do I Need for Big Bang?

There are two issues that make it difficult to figure out Big Bang's license requirements:

1. The modular (and in some cases swappable) componentized nature of Big Bang means choices affect license requirements. OS, Kubernetes Distribution, and Application decisions need to be made before license requirements can be sorted out.
1. Freemium applications often require a license to unlock features like HA (High Availability), advanced SSO functionality with authn, authz, and audit logging of federated users, or advanced compliance controls like FIPS 140-2 mode, compliance reporting, or audit logs.

## What Components Could Have Licenses?

1. OS / CSP(Cloud Service Providers) VM Images:
   * RHEL requires a subscription and comes with vendor support.
   * CSPs often offer licensed VM Images at additional per hour cost, these add features like offloading STIG/CIS OS hardening.
   * Several free Linux OS Distributions exist, including Ubuntu and free RHEL alternatives like Amazon Linux 2 and others. There are also tools like [openscap](https://www.open-scap.org/), which has ansible and bash scripts to automate STIG/CIS benchmark compliance for OS security to help automate DIY hardening of the OS.
1. Kubernetes Distributions:
   * RedHat OpenShift, VMware TKG, and D2IQ Konvoy each require a license, that comes with support and additional features, they each offer 30-90 day trial licenses.
   * There are free options like kubeadm, k0s, k3s, RKE2, talos-systems, and many other CNCF compliant distributions.
   * k0s, RKE2, and talos-systems are free options with optional paid Vendor Support.
1. Big Bang's Core Applications:
   * Many of the core applications are free open source software.
     * The default deployment of Big Bang does not require any licenses.
   * Twistlock is a core component that requires a license.
   * ElasticSearch is a core component that requires a license to unlock additional features, that could be considered required in some cases (more on this nuance below).
1. Big Bang's Supported AddOn Applications:
   * Also include a mix of free, freemium, and licensed products.
1. Big Bang Integration Support:
   * Big Bang is free, but support tiers are available for purchase through Platform One.

## Who Purchases the Licenses?

Licensing of products deployable by Big Bang are not covered by Big Bang or Platform One. As a general rule of thumb the acquisition of licenses is the responsibility of the end-user's organization, and product vendors should be contacted for support of their respective products. (Party Bus is an example of an exception to the rule of thumb.)

## Who Decides If a Licenced Feature in a Freemium Application Is a Hard Requirement?

* The Consumer of Big Bang, their security team, and their AO (Authorizing Official) need to decide if licensed features constitute a hard requirement or if free tier functionality can be considered at lower impact levels or unique use cases.
* In most cases licenses will be required due to security controls only being available in the fully licensed version; however, users may be able to hold off on licensed versions for non-ATO'd proof of concept deployments or risk acceptance by an AO for unique scenarios.
* Even without a hard requirement for a license (like in the case of a Kubernetes Cluster), consumers of Big Bang may still want to consider purchasing licenses or support contracts.

## Table to Help Elaborate on Nuances of Application Licensing

| Package                                                               | Purpose                                                                         | Licenses                                                                                                                                                        | Notes about Licensed Features and Support                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
|-----------------------------------------------------------------------|---------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| FluxCD                                                                | GitOps  (Prerequisite App)                                                      | Apache License 2.0  (Free/OSS)                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| Open Policy Agent Gatekeeper                                          | Policy Enforcement  (Core App)                                                  | Apache License 2.0  (Free/OSS)                                                                                                                                  | * [Styra](https://www.openpolicyagent.org/support) is the original creator of OPA and can offer commercial support.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Kyverno                                          | Policy Enforcement  (Core App)                                                  | Apache License 2.0  (Free/OSS)                                                                                                                                  | * Kyverno is a fully open-source product, however there are [multiple companies](https://kyverno.io/support/) which provide paid support services for it.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Istio Controlplane, Istio Operator,  and Kiali                        | Service Mesh, Operator, and  Service Mesh Dashboard  (Core App)                 | Apache License 2.0  (Free/OSS)                                                                                                                                  | * [Tetrate](https://www.tetrate.io/) is an Istio Vendor that can offer commercial support.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| Jaeger                                                                | APM (Application Performance Monitoring)  / Tracing  (Core App)                 | Apache License 2.0  (Free/OSS)                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| Prometheus                                           | Metrics and monitoring. (Core App)                                            | Apache License 2.0  (Free/OSS)                                       |              |
| AlertManager                                           | Alerting. (Core App)                                            | Apache License 2.0  (Free/OSS)                                       |              |
| Loki                                           | Log aggregation. (Core App)                                            | GNU Affero General Public License v3.                                       |              |
| Grafana                                           | Dashboard. (Core App)                                            | GNU Affero General Public License v3.                                       |              |
| Harbor                                           | Container and chart registry. (AddOn App)                                            | Apache License 2.0  (Free/OSS)                                       |              |
| Tempo (Grafana)                                           | Service-mesh trace collector. (AddOn App)                                            | GNU Affero General Public License v3.                                       |              |
| Fluentbit                                                             | Log Shipper  (Core App)                                                         | Apache License 2.0  (Free/OSS)                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| ECK (Elastic Cloud on Kubernetes)  (ElasticSearch and Kibana)         | Log Storage and Log Dashboard  (Core App)                                       | [Elastic License](https://github.com/elastic/cloud-on-k8s/blob/master/LICENSE.txt)  (Freemium)                                                                  | **Enterprise features of note:** Kibana SSO, authn, authz, FIPS 140-2 mode, audit logging require an enterprise tier license.  **Free tier notes:** BigBang's Authservice/Authentication Proxy could be put in front of Kibana to achieve basic SSO with all or nothing access.  PartyBus uses licensed ElasticSearch  <https://www.elastic.co/subscriptions> [licensing](package-architecture/elasticsearch-kibana.md#licensing)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| Cluster Auditor                                                       | Collects OPA GK events and sends them to   ElasticSearch for Review  (Core App) | Apache License 2.0  (Free/OSS)                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| Twistlock / Prisma Cloud Compute                                            | Runtime Security, Security Dashboard,  Intrusion Prevention  (Core App)         | Prisma Cloud Compute License  (Paid Product requiring a license)                                                                                           | **Prisma Cloud License is required for an ATO'd cluster.** [Considering investigating alternatives](https://repo1.dso.mil/groups/platform-one/big-bang/-/epics/74)  Licenses are sold per node. Each defender on a node uses 7 credits and the credits are purchased in bundles of 100 credits.   <https://docs.paloaltonetworks.com/prisma/prisma-cloud/prisma-cloud-admin-compute/welcome/licensing>  <https://docs.paloaltonetworks.com/prisma/prisma-cloud/20-09/prisma-cloud-compute-edition-admin/install/install_kubernetes.html>  [licensing](package-architecture/twistlock.md#licensing)                                                                                                                                                                                                                                                                                                                                                          |
| ArgoCD                                                                | GitOps  (AddOn App)                                                             | Apache License 2.0  (Free/OSS)                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| Velero                                                                | Backup and Recovery of Persistent Volumes  (AddOn App)                          | Apache License 2.0  (Free/OSS)                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| Keycloak                                                              | SSO (Single Sign On) and Federated Authn.  (AddOn App)                          | Apache License 2.0  (Free/OSS)                                                                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| Authservice (and HA Proxy)                                            | SSO Authentication Proxy  (AddOn App)                                           | Apache License 2.0   & GNU General Public License Version 2(Free/OSS)                                                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| Mattermost, Mattermost Operator                                       | Self Hosted Chat  (AddOn App)                                                   | [Mattermost is comprised of Multiple Licenses](<https://mattermost.org/licensing/>)                                                                             | **Enterprise features of note:** HA, Additional SSO options, prometheus metrics integration, Elasticsearch integration to optimize searching/indexing, Compliance Reporting, Audit Logs, Advanced roles and permissions.  **Free tier notes:** A non-HA deployment can quickly auto heal thanks to Kubernetes, the free tier can use Gitlab or P1's Keycloak implementation for Federated SSO. (MM Plugins don't need the paid version, but the need a single node instance or the paid HA for cluster awareness to prevent duplicate triggering of functions.)  PartyBus uses the Enterprise E20 licensed version.  [licensing](package-architecture/mattermost.md#licensing)  <https://mattermost.org/licensing/>  <https://mattermost.com/pricing-self-managed/>                                                                                                                                                                                            |
| Minio, Minio Operator                                                 | Self Hosted S3 API compatible object storage  (AddOn App)                       | Affero General Public License Version 3  (Free/OSS)                                                                                                             | Commercial Support is Available:  <https://min.io/pricing>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| Nexus                                                                 | Generic Artifact Repository  (AddOn App)                                        | Nexus Repository OSS: Eclipse Public License v1.0  Nexus Repository Pro: Paid Licensed product                                                                  | **Enterprise features of note:** HA, SAML SSO, Auth Token Support  **Free tier notes:** A non-HA deployment can quickly auto heal thanks to Kubernetes, AWS S3 blob storage.  <https://www.sonatype.com/products/repository-oss-vs-pro-features>  <https://www.sonatype.com/products/pricing>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| Gitlab, Gitlab Runners                                                | GitRepo, Container Registry, and   CICD Software Factory  (AddOn App)           | Gitlab Community Edition: MIT Expat license  Gitlab Enterprise Edition: (multiple tiers)                                                                        | **Premium features of note:** Release Controls, Project Management  **Ultimate features of note:** Unlimited Guest Users, Advanced Security Testing (Note this functionality comes from container images that may not yet be in Iron Bank)  **Free tier notes:** Free tier is fine for Proof of Concepts, but the Release Controls in Premium tier contain security controls that would be necessary for a cATO pipeline.  Party Bus has multiple instances of Gitlab, most use Premium, a few use Ultimate.  Party Bus's Gitlab pipelines integrate with additional licensed apps: Twistlock, Anchore, [Fortify](https://repo1.dso.mil/big-bang/product/packages/fortify), [SD Elements](https://www.securitycompass.com/sdelements/), and others. (This is offered as a data point, it doesn't mean these are required for a cATO pipeline, the Consumer of Big Bang's AO makes that call.)  <https://about.gitlab.com/pricing/#self-managed>  <https://gitlab.com/gitlab-org/gitlab-foss/-/tree/master#editions> |
| SonarQube Community Edition                                           | Static Code Analysis  (AddOn App)                                               | SonarQube CE: GNU Lesser GPL License v3  (Community Edition is Free/OSS)                                                                                        | An Enterprise Edition Exists, but is not bundled by Big Bang                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| Vault                                           | Secret management (AddOn App)                                            | Mozilla Public License 2.0                                        |              |
| Metrics Server                                           | Scalable, efficient source of container resource metrics. (AddOn App)                                            | Apache License 2.0  (Free/OSS)                                      |              |
| NeuVector                                           | Zero-trust container security. (AddOn App)                                            | Apache License 2.0  (Free/OSS)                                         
                     |              |
| Fortify                                           | Software security center. (AddOn App)                                            | Helm Chart: MIT Expat license   SSC: Proprietary license provided by Micro Focus                                         |              |